﻿using Spectral1.DATA_ACCESS;
using Spectral1_VBClassLibrary;
using System;
using System.Drawing;
using System.Windows.Forms;
using WarmBreeze_DataLibrary;

namespace Spectral1.BUSINESS_LOGIC
{
    public class BL_DGV
    {
        #region "============= DECLARATIONS ==============="
        private CodeGen_DS_Spectral _CGS;
        private CodeGen_DS_Spectral_System _CGSS;
        public const string default_text = "<None>";
        public Color non_zero_color = System.Drawing.ColorTranslator.FromHtml("#FFE08D");
        #endregion

        #region "============ METHODS ================"

        public BL_DGV(CodeGen_DS_Spectral CGS, CodeGen_DS_Spectral_System CGSS)
        {
            _CGS = CGS;
            _CGSS = CGSS;
        }

        public void InitialisePatchSetDGV(ref PL_UC_AddDeleteDGV DGV)
        {
            I_GenericCodeGenNonSortableTable i_tcps = (I_GenericCodeGenNonSortableTable)_CGS.Table_patch_set;
            DGVColumnConfigs PSC = new DGVColumnConfigs();
            PSC.AddStringColumn("PSID", "patch_set_id", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, 50, true, true, 50, "PatchSet ID", false, true);
            PSC.AddStringColumn("PatchSet name", "patch_set_name", DataGridViewAutoSizeColumnMode.Fill, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 100, 100, true, false, 50, "PatchSet name", false, true);

            DGV.ColumnConfigs = PSC;
            DGV.DGVConfig.HeaderRowHeight = 32;
            DGV.EX_Initialise(ref i_tcps, "PatchSet", 500, false);
            _CGS.Table_patch_set.DefaultRowValues.patch_set_name = default_text;
            DGV.DGV.DefaultCellStyle.Font = new Font("Segoe UI", 9, FontStyle.Regular);
        }

        public void InitialisePatchSetPatchesDGV(ref PL_UC_AddDeleteDGV DGV)
        {
            I_GenericCodeGenNonSortableTable i_tcpsp = (I_GenericCodeGenNonSortableTable)_CGS.Table_patch_set_patches;
            DGVColumnConfigs PSPC = new DGVColumnConfigs();
            PSPC.AddStringColumn("PSID", "patch_set_id", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, 50, false, true, 50, "PatchSet ID", false, true);
            PSPC.AddStringColumn("PSPID", "patch_set_patches_id", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, 50, true, true, 50, "PatchSet Patches ID", false, true);
            BindingSource bs = new BindingSource();
            bs.DataSource = _CGS.Table_patch.DT;
            PSPC.AddComboColumn("Patch", "patch_id", DataGridViewAutoSizeColumnMode.Fill, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 50, true, false, 70, bs, "patch_name", "patch_id", "Patch", true);
            PSPC.AddIntegerNumberColumn("Sort order", "sort_order", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, false, false, 50, "Sort order", true, 0, 65535);

            DGV.ColumnConfigs = PSPC;
            DGV.DGVConfig.HeaderRowHeight = 32;
            DGV.EX_Initialise(ref i_tcpsp, "PatchSet patch", DA_Spectral.patches_per_patchset, true);
            DGV.DGV.EX_TurnOffAllSorting();
            DGV.HideAddDelete();
            DGV.DGV.DefaultCellStyle.Font = new Font("Segoe UI", 9, FontStyle.Regular);
        }

        public DGVColumnConfigs get_patch_dgv_column_configs()
        {
            DGVColumnConfigs PC = new DGVColumnConfigs();
            PC.AddStringColumn("PID", "patch_id", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, 50, false, true, 50, "Patch ID", false, true);
            PC.AddStringColumn("patch_guid8", "patch_guid8", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, 50, false, true, 50, "patch_guid8", false, true);
            PC.AddStringColumn("Patch name", "patch_name", DataGridViewAutoSizeColumnMode.Fill, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, 100, true, false, 50, "Patch name", false, true);
            PC.AddComboColumn("Type", "patch_type_id", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, false, false, 80, _CGSS.Table_patch_type.Table_BindingSource, "patch_type_name", "patch_type_id", "Patch type", true);
            PC.AddComboColumn("Category", "patch_category_id", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, false, false, 80, _CGSS.Table_patch_category.Table_BindingSource, "patch_category_name", "patch_category_id", "Patch category", true);
            PC.AddComboColumn("WaveformSet", "waveform_set_id", DataGridViewAutoSizeColumnMode.Fill, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 50, false, false, 70, _CGS.Table_waveform_set.Table_BindingSource, "waveform_set_name", "waveform_set_id", "WaveformSet", true);
            PC.AddComboColumn("Body resonance filter", "body_resonance_filter_id", DataGridViewAutoSizeColumnMode.Fill, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 50, false, false, 70, _CGS.Table_body_resonance_filter.Table_BindingSource, "body_resonance_filter_name", "body_resonance_filter_id", "Body resonance filter", true);
            PC.AddCheckBoxColumn("Sustain", "sustain_enabled", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), 20, false, false, 50, "Sustain enabled");
            PC.AddCheckBoxColumn("Pitch-bend", "pitch_bend_enabled", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), 20, false, false, 50, "Pitch-bend enabled");
            PC.AddCheckBoxColumn("Portamento", "portamento_enabled", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), 20, false, false, 50, "Portamento enabled");
            PC.AddIntegerNumberColumn("Portamento rate", "portamento_rate", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, false, false, 50, "Portamento rate", true, 0, 65535);
            PC.AddIntegerNumberColumn("Regular de-tune", "degree_of_regular_detuning", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, false, false, 50, "Degree of regular de-tuning", true, 0, 65535);
            PC.AddIntegerNumberColumn("Random de-tune", "degree_of_random_detuning", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, false, false, 50, "Degree of random de-tuning", true, 0, 65535);
            PC.AddIntegerNumberColumn("Random phase", "degree_of_random_phase", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, false, false, 50, "Degree of random phase", true, 0, 65535);
            PC.AddComboColumn("Timbre CC1", "timbre_controller1_source", DataGridViewAutoSizeColumnMode.Fill, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 50, false, false, 70, _CGSS.Table_cc_source.Table_BindingSource, "cc_source_name", "cc_source_id", "Timbre continuous controller source 1", true);
            PC.AddComboColumn("Timbre CC2", "timbre_controller2_source", DataGridViewAutoSizeColumnMode.Fill, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 50, false, false, 70, _CGSS.Table_cc_source.Table_BindingSource, "cc_source_name", "cc_source_id", "Timbre continuous controller source 2", true);
            PC.AddIntegerNumberColumn("Layers", "active_layers", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, false, false, 50, "Active layers", true, 1, 3);
            PC.AddIntegerNumberColumn("Detuning mode", "detuning_mode_id", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, false, false, 50, "Detuning mode", true, 0, 255);
            PC.AddIntegerNumberColumn("Layer1 de-tune", "layer0_st_inc_q11_5_detune", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, false, false, 50, "Layer 1 de-tune", true, 0, 255);
            PC.AddIntegerNumberColumn("Layer2 de-tune", "layer1_st_inc_q11_5_detune", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, false, false, 50, "Layer 2 de-tune", true, 0, 255);
            PC.AddIntegerNumberColumn("REALLY PATCH GAIN", "layer2_st_inc_q11_5_detune", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, false, false, 50, "Layer 3 de-tune", true, 0, 255);
            PC.AddComboColumn("Timbre mode", "timbre_mode", DataGridViewAutoSizeColumnMode.Fill, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 50, false, false, 70, _CGSS.Table_timbre_mode.Table_BindingSource, "timbre_mode_name", "timbre_mode_id", "Timbre mode", true);

            PC.AddCheckBoxColumn("LFO cut-off", "lfo_cutoff_env_enabled", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), 20, false, false, 50, "LFO for cut-off enabled");
            PC.AddIntegerNumberColumn("LFO cut-off freq", "lfo_cutoff_env_default_wt_inc_q11_5", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, false, false, 50, "Layer 3 de-tune", true, 0, 65535);
            PC.AddComboColumn("LFO cut-off freq CC", "lfo_cutoff_env_freq_cc_source", DataGridViewAutoSizeColumnMode.Fill, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 50, false, false, 70, _CGSS.Table_cc_source.Table_BindingSource, "cc_source_name", "cc_source_id", "LFO cut-off frequency continuous controller source", true);
            PC.AddComboColumn("LFO cut-off depth CC", "lfo_cutoff_env_depth_cc_source", DataGridViewAutoSizeColumnMode.Fill, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 50, false, false, 70, _CGSS.Table_cc_source.Table_BindingSource, "cc_source_name", "cc_source_id", "LFO cut-off depth continuous controller source", true);

            PC.AddCheckBoxColumn("Tremolo", "trem_env_enabled", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), 20, false, false, 50, "LFO for Tremolo enabled");
            PC.AddIntegerNumberColumn("Tremolo freq", "trem_env_default_wt_inc_q11_5", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, false, false, 50, "Layer 3 de-tune", true, 0, 65535);
            PC.AddComboColumn("Tremolo freq CC", "trem_env_freq_cc_source", DataGridViewAutoSizeColumnMode.Fill, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 50, false, false, 70, _CGSS.Table_cc_source.Table_BindingSource, "cc_source_name", "cc_source_id", "Tremolo frequency continuous controller source", true);
            PC.AddComboColumn("Tremolo depth CC", "trem_env_depth_cc_source", DataGridViewAutoSizeColumnMode.Fill, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 50, false, false, 70, _CGSS.Table_cc_source.Table_BindingSource, "cc_source_name", "cc_source_id", "Tremolo depth continuous controller source", true);

            PC.AddCheckBoxColumn("Vibrato", "vibr_env_enabled", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), 20, false, false, 50, "LFO for Vibrato enabled");
            PC.AddIntegerNumberColumn("Vibrato freq", "vibr_env_default_wt_inc_q11_5", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, false, false, 50, "Layer 3 de-tune", true, 0, 65535);
            PC.AddComboColumn("Vibrato freq CC", "vibr_env_freq_cc_source", DataGridViewAutoSizeColumnMode.Fill, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 50, false, false, 70, _CGSS.Table_cc_source.Table_BindingSource, "cc_source_name", "cc_source_id", "Vibrato frequency continuous controller source", true);
            PC.AddComboColumn("Vibrato depth CC", "vibr_env_depth_cc_source", DataGridViewAutoSizeColumnMode.Fill, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 50, false, false, 70, _CGSS.Table_cc_source.Table_BindingSource, "cc_source_name", "cc_source_id", "Vibrato depth continuous controller source", true);

            PC.AddIntegerNumberColumn("Key-scaling split point", "key_scale_split_note_id", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, false, false, 50, "Layer 3 de-tune", true, 0, 65535);
            return PC;
        }

        public void InitialisePatchDGV(ref PL_UC_AddDeleteDGV DGV)
        {
            I_GenericCodeGenNonSortableTable i_tcp = (I_GenericCodeGenNonSortableTable)_CGS.Table_patch;         
            DGV.ColumnConfigs = get_patch_dgv_column_configs(); 
            DGV.DGVConfig.HeaderRowHeight = 32;
            DGV.EX_Initialise(ref i_tcp, "Patch", 500, false);
            DGV.DGV.DefaultCellStyle.Font = new Font("Segoe UI", 9, FontStyle.Regular);

            _CGS.Table_patch.DefaultRowValues.active_layers = 1;
            _CGS.Table_patch.DefaultRowValues.degree_of_random_detuning = 0;
            _CGS.Table_patch.DefaultRowValues.degree_of_random_phase = 0;
            _CGS.Table_patch.DefaultRowValues.degree_of_regular_detuning = 0;
            _CGS.Table_patch.DefaultRowValues.layer0_st_inc_q11_5_detune = 0;
            _CGS.Table_patch.DefaultRowValues.layer1_st_inc_q11_5_detune = 0;
            _CGS.Table_patch.DefaultRowValues.layer2_st_inc_q11_5_detune = 100;
            _CGS.Table_patch.DefaultRowValues.layer0_st_inc_q11_5_detune = 0;
            _CGS.Table_patch.DefaultRowValues.patch_category_id = 0;
            _CGS.Table_patch.DefaultRowValues.patch_name = default_text;
            _CGS.Table_patch.DefaultRowValues.patch_type_id = 0;
            _CGS.Table_patch.DefaultRowValues.pitch_bend_enabled = 0;
            _CGS.Table_patch.DefaultRowValues.portamento_enabled = 0;
            _CGS.Table_patch.DefaultRowValues.sustain_enabled = 1;
            _CGS.Table_patch.DefaultRowValues.waveform_set_id = 0;
            _CGS.Table_patch.DefaultRowValues.body_resonance_filter_id = 0;
            _CGS.Table_patch.DefaultRowValues.portamento_rate = 100;
            _CGS.Table_patch.DefaultRowValues.key_scale_split_note_id = DA_Spectral.c4_note_number;
        }

        public void InitialiseBiquadEQDGV(ref PL_UC_AddDeleteDGV DGV)
        {
            I_GenericCodeGenNonSortableTable i_tbq = (I_GenericCodeGenNonSortableTable)_CGS.Table_biquad_eq;
            DGVColumnConfigs BQC = new DGVColumnConfigs();
            BQC.AddStringColumn("PID", "patch_id", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, 50, false, true, 50, "Patch ID", false, true);
            BQC.AddStringColumn("BQID", "biquad_eq_id", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, 50, true, true, 50, "Biquad Filter ID", false, true);
            BQC.AddComboColumn("Type", "filter_type_id", DataGridViewAutoSizeColumnMode.Fill, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 50, true, false, 70, _CGSS.Table_filter_type.Table_BindingSource, "filter_type_name", "filter_type_id", "Filter type", true);

            BQC.AddRealNumberColumn("a0", "a0", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, false, false, 50, "a0", true, 0, 65535);
            BQC.AddRealNumberColumn("a1", "a1", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, false, false, 50, "a1", true, 0, 65535);
            BQC.AddRealNumberColumn("a2", "a2", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, false, false, 50, "a2", true, 0, 65535);
            BQC.AddRealNumberColumn("b1", "b1", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, false, false, 50, "b1", true, 0, 65535);
            BQC.AddRealNumberColumn("b2", "b2", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, false, false, 50, "b2", true, 0, 65535);

            BQC.AddRealNumberColumn("Fc(Hz)", "fc", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, true, false, 50, "Cut-off frequency", true, 20, 25000);
            BQC.AddRealNumberColumn("Q", "q", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, true, false, 50, "Quality factor", true, 0, 20);
            BQC.AddRealNumberColumn("Peak gain(dB)", "peak_gain", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, true, false, 50, "Peak gain", true, -30, 30);

            DGV.ColumnConfigs = BQC;
            DGV.DGVConfig.HeaderRowHeight = 32;
            DGV.DGVConfig.EditMode = DataGridViewEditMode.EditOnKeystroke;
            DGV.EX_Initialise(ref i_tbq, "Filter", 10, true);
            DGV.HideAddDelete();

            DGV.DGV.EX_SetColumnNumberFormat("peak_gain", "N1");
            DGV.DGV.EX_SetColumnNumberFormat("q", "N1");
            DGV.DGV.EX_SetColumnNumberFormat("fc", "###,##0");
            DGV.DGV.DefaultCellStyle.Font = new Font("Segoe UI", 9, FontStyle.Regular);
        }

        public void InitialiseLFOsDGV(ref PL_UC_AddDeleteDGV DGV)
        {
            I_GenericCodeGenNonSortableTable i_tclfo = (I_GenericCodeGenNonSortableTable)_CGS.Table_lfo_envelope_config;
            DGVColumnConfigs LFOC = new DGVColumnConfigs();
            //DGV_Config LFOC_D = new DGV_Config();
            //LFOC_D.DataSource = CGS.Table_lfo_envelope_config.Table_BindingSource;
            LFOC.AddStringColumn("PID", "patch_id", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, 50, false, true, 50, "Patch ID", false, true);
            LFOC.AddComboColumn("LFO", "lfo_envelope_config_id", DataGridViewAutoSizeColumnMode.Fill, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 50, true, true, 70, _CGSS.Table_lfo.Table_BindingSource, "lfo_name", "lfo_id", "Low-frequency oscillator", false);
            LFOC.AddCheckBoxColumn("Enabled", "enabled", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), 20, true, false, 50, "Enabled");
            LFOC.AddComboColumn("Wave type", "lfo_wave_type_id", DataGridViewAutoSizeColumnMode.Fill, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, true, false, 20, _CGSS.Table_lfo_wave_type.Table_BindingSource, "lfo_wave_type_name", "lfo_wave_type_id", "Wave type", true);
            LFOC.AddRealNumberColumn("Freq Hz", "default_wt_inc_q11_5", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, true, false, 50, "Frequency", true, 0, 40);
            LFOC.AddComboColumn("Freq CC", "freq_cc_source", DataGridViewAutoSizeColumnMode.Fill, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 50, true, false, 70, _CGSS.Table_cc_source.Table_BindingSource, "cc_source_name", "cc_source_id", "Frequency continuous controller source", true);
            LFOC.AddComboColumn("Depth CC", "depth_cc_source", DataGridViewAutoSizeColumnMode.Fill, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 50, true, false, 70, _CGSS.Table_cc_source.Table_BindingSource, "cc_source_name", "cc_source_id", "Depth continuous controller source", true);
            //pL_UC_AddDeleteDGV_LFOs.DGVConfig = LFOC_D;
            DGV.ColumnConfigs = LFOC;
            DGV.DGVConfig.HeaderRowHeight = 32;
            DGV.EX_Initialise(ref i_tclfo, "LFO", 500, false);
            DGV.DGV.EX_SetColumnNumberFormat("default_wt_inc_q11_5", "N1");
            DGV.HideAddDelete();
            DGV.DGV.DefaultCellStyle.Font = new Font("Segoe UI", 9, FontStyle.Regular);
        }

        public void InitialiseADSRSectionConfigDGV(ref PL_UC_AddDeleteDGV DGV)
        {
            I_GenericCodeGenNonSortableTable i_tcs = (I_GenericCodeGenNonSortableTable)_CGS.Table_adsr_section;
            DGVColumnConfigs ADSRSC = new DGVColumnConfigs();
            ADSRSC.AddStringColumn("PID", "patch_id", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, 50, false, true, 50, "Patch ID", false, true);
            ADSRSC.AddComboColumn("Section", "adsr_section_id", DataGridViewAutoSizeColumnMode.None, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 50, true, true, 80, _CGSS.Table_adsr_section.Table_BindingSource, "adsr_section_name", "adsr_section_id", "Section", false);
            ADSRSC.AddCheckBoxColumn("On", "flag_active", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), 20, true, false, 50, "Active");
            ADSRSC.AddIntegerNumberColumn("Dur ms", "end_time_ms", DataGridViewAutoSizeColumnMode.Fill, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 10, true, false, 20, "Section duration in milliseconds", true, 0, 65534);
            ADSRSC.AddRealNumberColumn("End KSU %", "end_time_ms_keyscale_upper", DataGridViewAutoSizeColumnMode.Fill, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 10, true, false, 50, "End time Key Scaling Upper, % per note", true, -200, 200);
            ADSRSC.AddRealNumberColumn("End KSL %", "end_time_ms_keyscale_lower", DataGridViewAutoSizeColumnMode.Fill, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 10, true, false, 50, "End time Key Scaling Lower, % per note", true, -200, 200);
            ADSRSC.AddComboColumn("Sample", "inharmonic_sample_id", DataGridViewAutoSizeColumnMode.Fill, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 30, true, false, 100, _CGSS.Table_sample.Table_BindingSource, "sample_name", "sample_id", "Inharmonic sample", true);
            ADSRSC.AddComboColumn("Sample mode", "inharmonic_sample_playback_mode_id", DataGridViewAutoSizeColumnMode.None, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 10, true, false, 120, _CGSS.Table_sample_playback_mode.Table_BindingSource, "sample_playback_mode_name", "sample_playback_mode_id", "Inharmonic sample playback mode", true);
            DGV.ColumnConfigs = ADSRSC;
            DGV.HideAddDelete();
            DGV.DGVConfig.HeaderRowHeight = 90;
            DGV.DGVConfig.HeaderCellAlignment = DataGridViewContentAlignment.BottomCenter;
            DGV.EX_Initialise(ref i_tcs, "ADSR Section", 10, false);
            DGV.DGV.EX_SetColumnNumberFormat("end_time_ms_keyscale_upper", "N1");
            DGV.DGV.EX_SetColumnNumberFormat("end_time_ms_keyscale_lower", "N1");

            DGV.DGV.EX_TurnOffAllSorting();
            DGV.DGV.RowTemplate.MinimumHeight = 32;

            _CGS.Table_adsr_section.DefaultRowValues.inharmonic_sample_playback_mode_id = Convert.ToInt32(DA_Spectral.inharmonic_sample_playback_modes.sample_playback_mode_one_shot);

            DGV.DGV.Columns["end_time_ms"].HeaderCell.Style.BackColor = Color.Gray;
            DGV.DGV.Columns["end_time_ms_keyscale_upper"].HeaderCell.Style.BackColor = Color.Gray;
            DGV.DGV.Columns["end_time_ms_keyscale_lower"].HeaderCell.Style.BackColor = Color.Gray;

            DGV.DGV.EX_BoldNonZero = true;
            DGV.DGV.EX_BoldNonZeroColor = non_zero_color;
            DGV.DGV.EX_BoldNonZeroFromColIndex = 3;
            DGV.DGV.DefaultCellStyle.Font = new Font("Segoe UI", 9, FontStyle.Regular);

            ((DataGridViewComboBoxColumn)(DGV.DGV.Columns["inharmonic_sample_id"])).DropDownWidth = 150;
        }

        public void InitialiseADSRSectionEnvelopeConfigDGV(ref PL_UC_AddDeleteDGV DGV)
        {
            I_GenericCodeGenNonSortableTable i_tcse = (I_GenericCodeGenNonSortableTable)_CGS.Table_adsr_section_envelope_config;
            DGVColumnConfigs ADSRSEC = new DGVColumnConfigs();
            ADSRSEC.AddStringColumn("PID", "patch_id", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, 50, false, true, 50, "Patch ID", false, true);
            ADSRSEC.AddComboColumn("Section", "adsr_section_id", DataGridViewAutoSizeColumnMode.Fill, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 50, false, true, 70, _CGSS.Table_adsr_section.Table_BindingSource, "adsr_section_name", "adsr_section_id", "Section", false);
            ADSRSEC.AddComboColumn("Envelope", "adsr_section_envelope_config_id", DataGridViewAutoSizeColumnMode.None, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 50, true, true, 120, _CGSS.Table_envelope.Table_BindingSource, "envelope_name", "envelope_id", "Envelope", false);
            ADSRSEC.AddComboColumn("Type", "depth_env_type_id", DataGridViewAutoSizeColumnMode.None, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 100, true, false, 90, _CGSS.Table_envelope_type.Table_BindingSource, "envelope_type_name", "envelope_type_id", "Envelope type", true);

            ADSRSEC.AddRealNumberColumn("Target %", "depth_env_target", DataGridViewAutoSizeColumnMode.Fill, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 10, true, false, 50, "Target level", true, 0, 100);
            ADSRSEC.AddRealNumberColumn("Target KSU%", "depth_env_target_keyscale_upper", DataGridViewAutoSizeColumnMode.Fill, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 10, true, false, 50, "Target level Key Scaling Upper, % per note", true, -25, 25);
            ADSRSEC.AddRealNumberColumn("Target KSL%", "depth_env_target_keyscale_lower", DataGridViewAutoSizeColumnMode.Fill, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 10, true, false, 50, "Target level Key Scaling Lower, % per note", true, -25, 25);

            ADSRSEC.AddIntegerNumberColumn("Linear delta", "depth_env_lin_delta", DataGridViewAutoSizeColumnMode.Fill, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 10, true, false, 50, "Linear delta change", true, 0, 65535);
            ADSRSEC.AddIntegerNumberColumn("Linear delta KSU%", "depth_env_lin_delta_keyscale_upper", DataGridViewAutoSizeColumnMode.Fill, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 10, true, false, 50, "Linear delta change Key Scaling Upper, % per note", true, -100, 100);
            ADSRSEC.AddIntegerNumberColumn("Linear delta KSL%", "depth_env_lin_delta_keyscale_lower", DataGridViewAutoSizeColumnMode.Fill, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 10, true, false, 50, "Linear delta change Key Scaling Lower, % per note", true, -100, 100);

            ADSRSEC.AddRealNumberColumn("Exp mult %", "depth_env_exp_multiplier", DataGridViewAutoSizeColumnMode.Fill, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 10, true, false, 50, "Exponential multiplier", true, 0, 40);
            ADSRSEC.AddRealNumberColumn("Exp mult KSU%", "depth_env_exp_multiplier_keyscale_upper", DataGridViewAutoSizeColumnMode.Fill, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 10, true, false, 50, "Exponential multiplier Key Scaling Upper, % per note", true, -100, 100);
            ADSRSEC.AddRealNumberColumn("Exp mult KSL%", "depth_env_exp_multiplier_keyscale_lower", DataGridViewAutoSizeColumnMode.Fill, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 10, true, false, 50, "Exponential multiplier Key Scaling Lower, % per note", true, -100, 100);

            DGV.ColumnConfigs = ADSRSEC;
            DGV.HideAddDelete();
            DGV.DGVConfig.HeaderRowHeight = 90;
            DGV.DGVConfig.HeaderCellAlignment = DataGridViewContentAlignment.BottomCenter;
            DGV.EX_Initialise(ref i_tcse, "Envelope", 10, false);
            DGV.DGV.EX_TurnOffAllSorting();
            DGV.DGV.EX_SetColumnNumberFormat("depth_env_target", "N1");
            DGV.DGV.EX_SetColumnNumberFormat("depth_env_target_keyscale_upper", "N2");
            DGV.DGV.EX_SetColumnNumberFormat("depth_env_target_keyscale_lower", "N2");
            DGV.DGV.EX_SetColumnNumberFormat("depth_env_lin_delta_keyscale_upper", "N2");
            DGV.DGV.EX_SetColumnNumberFormat("depth_env_lin_delta_keyscale_lower", "N2");
            DGV.DGV.EX_SetColumnNumberFormat("depth_env_exp_multiplier", "N2");
            DGV.DGV.EX_SetColumnNumberFormat("depth_env_exp_multiplier_keyscale_upper", "N2");
            DGV.DGV.EX_SetColumnNumberFormat("depth_env_exp_multiplier_keyscale_lower", "N2");

            DGV.DGV.Columns["depth_env_target"].HeaderCell.Style.BackColor = Color.Gray;
            DGV.DGV.Columns["depth_env_target_keyscale_upper"].HeaderCell.Style.BackColor = Color.Gray;
            DGV.DGV.Columns["depth_env_target_keyscale_lower"].HeaderCell.Style.BackColor = Color.Gray;

            DGV.DGV.Columns["depth_env_exp_multiplier"].HeaderCell.Style.BackColor = Color.Gray;
            DGV.DGV.Columns["depth_env_exp_multiplier_keyscale_upper"].HeaderCell.Style.BackColor = Color.Gray;
            DGV.DGV.Columns["depth_env_exp_multiplier_keyscale_lower"].HeaderCell.Style.BackColor = Color.Gray;

            DGV.DGV.RowTemplate.MinimumHeight = 32;

            DGV.DGV.EX_BoldNonZero = true;
            DGV.DGV.EX_BoldNonZeroColor = non_zero_color;
            DGV.DGV.EX_BoldNonZeroFromColIndex = 3;
            DGV.DGV.DefaultCellStyle.Font = new Font("Segoe UI", 9, FontStyle.Regular);

            ((DataGridViewComboBoxColumn)(DGV.DGV.Columns["depth_env_type_id"])).DropDownWidth = 100;
        }

        public void InitialiseEnvelopeGainControlDGV(ref PL_UC_AddDeleteDGV DGV)
        {
            I_GenericCodeGenNonSortableTable i_tcwfs = (I_GenericCodeGenNonSortableTable)_CGS.Table_envelope_control;
            DGVColumnConfigs EGCC = new DGVColumnConfigs();
            EGCC.AddStringColumn("PID", "patch_id", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, 50, false, true, 50, "Patch ID", false, true);
            EGCC.AddComboColumn("Envelope", "envelope_control_id", DataGridViewAutoSizeColumnMode.None, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 50, true, true, 150, _CGSS.Table_envelope.Table_BindingSource, "envelope_name", "envelope_id", "Envelope", false);
            EGCC.AddRealNumberColumn("Initial Level%", "depth_initial_level", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 10, true, false, 50, "Initial level %", true, 0, 100);
            EGCC.AddComboColumn("Gain Controller", "gain_cc_source", DataGridViewAutoSizeColumnMode.Fill, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 50, true, false, 70, _CGSS.Table_cc_source.Table_BindingSource, "cc_source_name", "cc_source_id", "Envelope gain continuous controller source", true);

            DGV.ColumnConfigs = EGCC;
            DGV.DGVConfig.HeaderRowHeight = 32;
            DGV.EX_Initialise(ref i_tcwfs, "Envelope", 500, false);
            DGV.DGV.EX_TurnOffAllSorting();
            DGV.HideAddDelete();
            DGV.DGV.DefaultCellStyle.Font = new Font("Segoe UI", 9, FontStyle.Regular);

            _CGS.Table_envelope_control.DefaultRowValues.gain_cc_source = Convert.ToInt32(DA_Spectral.used_midi_cc.ucc_none);
            _CGS.Table_envelope_control.DefaultRowValues.depth_initial_level = 0;
        }

        public void InitialiseWaveFormSetDGV(ref PL_UC_AddDeleteDGV DGV)
        {
            I_GenericCodeGenNonSortableTable i_tcwfs = (I_GenericCodeGenNonSortableTable)_CGS.Table_waveform_set;
            DGVColumnConfigs WFSC = new DGVColumnConfigs();
            WFSC.AddStringColumn("WSID", "waveform_set_id", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, 50, false, true, 50, "WaveSet ID", false, true);
            WFSC.AddStringColumn("waveform_set_guid8", "waveform_set_guid8", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, 50, false, true, 50, "waveform_set_guid8", false, true);
            WFSC.AddStringColumn("WaveSet name", "waveform_set_name", DataGridViewAutoSizeColumnMode.Fill, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, 100, true, false, 50, "WaveSet name", false, true);
            WFSC.AddComboColumn("Timbre Mode", "timbre_mode", DataGridViewAutoSizeColumnMode.Fill, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 50, false, false, 70, _CGSS.Table_timbre_mode.Table_BindingSource, "timbre_mode_name", "timbre_mode_id", "Timbre mode", true);
            WFSC.AddComboColumn("Intensity CC", "intensity_controller_source", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 50, true, false, 70, _CGSS.Table_cc_source.Table_BindingSource, "cc_source_name", "cc_source_id", "Intensity controller source", true);
            WFSC.AddComboColumn("Waveform CC", "waveform_controller_source", DataGridViewAutoSizeColumnMode.Fill, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 50, false, false, 70, _CGSS.Table_cc_source.Table_BindingSource, "cc_source_name", "cc_source_id", "Waveform controller source", true);

            DGV.ColumnConfigs = WFSC;
            DGV.DGVConfig.HeaderRowHeight = 32;
            DGV.EX_Initialise(ref i_tcwfs, "WaveSet", 500, false);
            DGV.EX_SetRowFilter("waveform_set_id <> 0");
            DGV.DGV.EX_TurnOffAllSorting();
            DGV.DGV.DefaultCellStyle.Font = new Font("Segoe UI", 9, FontStyle.Regular);

            _CGS.Table_waveform_set.DefaultRowValues.waveform_set_name = default_text;
            _CGS.Table_waveform_set.DefaultRowValues.timbre_mode = Convert.ToInt32(DA_Spectral.timbre_modes.timbre_envelope);
            _CGS.Table_waveform_set.DefaultRowValues.intensity_controller_source = Convert.ToInt32(DA_Spectral.used_midi_cc.ucc_none);
            _CGS.Table_waveform_set.DefaultRowValues.waveform_controller_source = Convert.ToInt32(DA_Spectral.used_midi_cc.ucc_none);

        }

        public void InitialiseWaveFormDGV(ref PL_UC_AddDeleteDGV DGV)
        {
            I_GenericCodeGenNonSortableTable i_tw = (I_GenericCodeGenNonSortableTable)_CGS.Table_waveform;

            DGVColumnConfigs WC = new DGVColumnConfigs();
            WC.AddStringColumn("WSID", "waveform_set_id", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, 50, false, true, 50, "WaveSet ID", false, true);
            WC.AddStringColumn("WID", "waveform_id", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, 50, true, true, 50, "Waveform ID", false, true);
            WC.AddStringColumn("NSID", "note_sector_id", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, 50, true, true, 50, "Note Sector ID", false, true);
            WC.AddStringColumn("ILID", "intensity_layer_id", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, 50, true, true, 50, "Intensity layer ID", false, true);
            WC.AddStringColumn("Description", "description", DataGridViewAutoSizeColumnMode.Fill, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 50, 50, true, false, 50, "Description", false, true);
            DGV.ColumnConfigs = WC;
            DGV.DGVConfig.HeaderRowHeight = 32;
            DGV.EX_Initialise(ref i_tw, "Waveform", 10000, false);
            DGV.DGV.EX_TurnOffAllSorting();
            _CGS.Table_waveform.DefaultRowValues.description = default_text;
            DGV.DGV.DefaultCellStyle.Font = new Font("Segoe UI", 9, FontStyle.Regular);
        }

        public void InitialiseFilterDGV(ref PL_UC_AddDeleteDGV DGV)
        {
            I_GenericCodeGenNonSortableTable i_tcwfs = (I_GenericCodeGenNonSortableTable)_CGS.Table_body_resonance_filter;
            DGVColumnConfigs WFSC = new DGVColumnConfigs();
            WFSC.AddStringColumn("ID", "body_resonance_filter_id", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, 50, false, true, 50, "WaveSet ID", false, true);
            WFSC.AddStringColumn("body_resonance_filter_guid8", "body_resonance_filter_guid8", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, 50, false, true, 50, "body_resonance_filter_guid8", false, true);
            WFSC.AddStringColumn("Filter name", "body_resonance_filter_name", DataGridViewAutoSizeColumnMode.Fill, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, 100, true, false, 50, "WaveSet name", false, true);

            DGV.ColumnConfigs = WFSC;
            DGV.DGVConfig.HeaderRowHeight = 32;
            DGV.EX_Initialise(ref i_tcwfs, "Filter", 500, false);
            DGV.EX_SetRowFilter("body_resonance_filter_id <> 0");
            DGV.DGV.DefaultCellStyle.Font = new Font("Segoe UI", 9, FontStyle.Regular);

            _CGS.Table_body_resonance_filter.DefaultRowValues.body_resonance_filter_name = default_text;
            _CGS.Table_body_resonance_filter_band.DefaultRowValues.level = 255;
        }

        public void InitialisePerformanceDGV(ref PL_UC_AddDeleteDGV DGV)
        {
            I_GenericCodeGenNonSortableTable nst = (I_GenericCodeGenNonSortableTable)_CGS.Table_performance;
            DGVColumnConfigs CC = new DGVColumnConfigs();
            CC.AddStringColumn("PSID", "patch_set_id", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, 50, false, true, 50, "Patch Set ID", false, true);
            CC.AddStringColumn("ID", "performance_id", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, 50, true, true, 50, "Performance ID", false, true);
            CC.AddStringColumn("Performance name", "performance_name", DataGridViewAutoSizeColumnMode.Fill, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, 100, true, false, 50, "Performance name", false, true);
            CC.AddIntegerNumberColumn("HAAS delay ms", "haas_delay_ms", DataGridViewAutoSizeColumnMode.Fill, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, true, false, 50, "HAAS delay ms (for stereo widening)", true, 10, DA_Spectral.max_haas_delay);
            DGV.ColumnConfigs = CC;
            DGV.DGVConfig.HeaderRowHeight = 32;
            DGV.EX_Initialise(ref nst, "Performance", 500, false);
            DGV.HideAddDelete();
            DGV.DGV.ColumnHeadersHeight = 75;
            DGV.DGV.DefaultCellStyle.Font = new Font("Segoe UI", 9, FontStyle.Regular);

            _CGS.Table_performance.DefaultRowValues.performance_name = default_text;
        }

        public void InitialisePerformanceChannelDGV(ref PL_UC_AddDeleteDGV DGV)
        {
            I_GenericCodeGenNonSortableTable nst = (I_GenericCodeGenNonSortableTable)_CGS.Table_performance_channel;
            DGVColumnConfigs CC = new DGVColumnConfigs();
            CC.AddStringColumn("PSID", "patch_set_id", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, 50, false, true, 50, "Patch Set ID", false, true);
            CC.AddStringColumn("ID", "performance_id", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, 50, false, true, 50, "Performance ID", false, true);
            CC.AddComboColumn("Channel", "performance_channel_id", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 50, true, true, 70, _CGSS.Table_midi_channel.Table_BindingSource, "midi_channel_name", "midi_channel_id", "MIDI channel", false);
            BindingSource bs = new BindingSource();
            bs.DataSource = _CGS.Table_patch.DT;
            CC.AddComboColumn("Patch", "patch_id", DataGridViewAutoSizeColumnMode.Fill, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 50, true, false, 70, bs, "patch_name", "patch_id", "Patch", true);
            CC.AddRealNumberColumn("Volume%", "volume", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 10, true, false, 50, "Channel volume level", true, 0, 100);
            BindingSource bs1 = new BindingSource();
            bs1.DataSource = _CGSS.Table_midi_note.DT;
            CC.AddComboColumn("Range low", "note_range_low", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 50, false, false, 70, bs1, "midi_note_name", "midi_note_id", "Note range low", true);
            BindingSource bs2 = new BindingSource();
            bs2.DataSource = _CGSS.Table_midi_note.DT;
            CC.AddComboColumn("Range high", "note_range_high", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 50, false, false, 70, bs2, "midi_note_name", "midi_note_id", "Note range high", true);
            DGV.ColumnConfigs = CC;
            DGV.DGVConfig.HeaderRowHeight = 32;
            DGV.EX_Initialise(ref nst, "Channel", 500, false);
            DGV.DGV.EX_TurnOffAllSorting();
            DGV.HideAddDelete();
            DGV.DGV.DefaultCellStyle.Font = new Font("Segoe UI", 9, FontStyle.Regular);
        }

        public void InitialisePerformanceProcessorDGV(ref PL_UC_AddDeleteDGV DGV)
        {
            I_GenericCodeGenNonSortableTable nst = (I_GenericCodeGenNonSortableTable)_CGS.Table_performance_processor;
            DGVColumnConfigs CC = new DGVColumnConfigs();
            CC.AddStringColumn("PSID", "patch_set_id", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, 50, false, true, 50, "Patch Set ID", false, true);
            CC.AddStringColumn("ID", "performance_id", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, 50, false, true, 50, "Performance ID", false, true);
            CC.AddStringColumn("Processor ID", "performance_processor_id", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 20, 50, true, true, 50, "Processor ID", false, true);
            CC.AddComboColumn("Channel", "channel_id", DataGridViewAutoSizeColumnMode.Fill, DataGridViewContentAlignment.MiddleLeft, new Font("Arial", 10), DataGridViewColumnSortMode.Automatic, 50, true, false, 70, _CGSS.Table_midi_channel.Table_BindingSource, "midi_channel_name", "midi_channel_id", "MIDI channel", true);
            DGV.ColumnConfigs = CC;
            DGV.DGVConfig.HeaderRowHeight = 32;
            DGV.EX_Initialise(ref nst, "Processor", 500, false);
            DGV.DGV.EX_TurnOffAllSorting();
            DGV.HideAddDelete();
            DGV.DGV.DefaultCellStyle.Font = new Font("Segoe UI", 9, FontStyle.Regular);
        }

        public void InitialiseSystemSettingsDGV(ref PL_UC_AddDeleteDGV DGV)
        {
            I_GenericCodeGenNonSortableTable nst = (I_GenericCodeGenNonSortableTable)_CGS.Table_system_settings;
            DGVColumnConfigs CC = new DGVColumnConfigs();
            CC.AddIntegerNumberColumn("SSID", "system_settings_id", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10, FontStyle.Regular), DataGridViewColumnSortMode.Automatic, 20, false, true, 50, "System Settings ID", true, 0, 100);
            CC.AddIntegerNumberColumn("Default Performance bank", "default_performance_bank", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10, FontStyle.Regular), DataGridViewColumnSortMode.Automatic, 20, true, false, 50, "Default Performance bank (128 * MSB + LSB)", true, 0, 100000);
            CC.AddIntegerNumberColumn("Default Patch bank", "default_patch_bank", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10, FontStyle.Regular), DataGridViewColumnSortMode.Automatic, 20, true, false, 50, "Default Patch bank  (128 * MSB + LSB)", true, 0, 100000);
            CC.AddIntegerNumberColumn("Data Schema Version", "data_schema_version", DataGridViewAutoSizeColumnMode.AllCells, DataGridViewContentAlignment.MiddleCenter, new Font("Arial", 10, FontStyle.Regular), DataGridViewColumnSortMode.Automatic, 20, true, true, 50, "The version of the data schema used in the system. Upgrades may have a different version.", true, 0, 100);
            DGV.ColumnConfigs = CC;
            DGV.DGVConfig.HeaderRowHeight = 32;
            DGV.EX_Initialise(ref nst, "System Setting", 500, false);
            DGV.DGV.BackgroundColor = Color.Green;
            DGV.DGV.EX_TurnOffAllSorting();
            DGV.HideAddDelete();
            DGV.DGV.DefaultCellStyle.Font = new Font("Segoe UI", 9, FontStyle.Regular);

        }

        #endregion
    }
}
